#!/usr/bin/env python3
import os
import lab
import json
import unittest
import doctest
from copy import deepcopy

import sys
sys.setrecursionlimit(100000)

TEST_DIRECTORY = os.path.dirname(__file__)

class TestPacking(unittest.TestCase):
    def run_case(self, case):
        infile = os.path.join(TEST_DIRECTORY, 'cases', f'{case}.in')
        with open(infile, 'r') as f:
            inputs = json.loads(f.read())
        outfile = os.path.join(TEST_DIRECTORY, 'cases', f'{case}.out')
        with open(outfile, 'r') as f:
            soln_count = json.loads(f.read().replace("\'", '"').replace("(", '[').replace(")", ']'))
        print(inputs['test'])
        tent_size = tuple(inputs['tent_size'])
        missing_squares = {(r, c) for r, c in inputs['rocks']}
        sub = lab.pack(tent_size, missing_squares)
        self.validate_result(sub, inputs, soln_count)

    def test_01(self):
        self.run_case('1')

    def test_02(self):
        self.run_case('2')

    def test_03(self):
        self.run_case('3')

    def test_04(self):
        self.run_case('4')

    def test_05(self):
        self.run_case('5')

    def test_06(self):
        self.run_case('6')

    def test_07(self):
        self.run_case('7')

    def test_08(self):
        self.run_case('8')

    def test_09(self):
        self.run_case('9')

    def test_10(self):
        self.run_case('10')

    def validate_result(self, sub, inputs, soln_count):
        # soln_count: number of bags in the solution
        if soln_count == 0:
            soln_count = None
        if soln_count == None:
            self.assertEqual(soln_count, sub, "Proposed a packing for an impossible tent!")
        elif sub == False:
            self.assertEqual(soln_count, sub, "Failed to find a solution where one exists.")
        elif type(sub) != list:
            self.assertTrue(False, "Result should be a list.")
        elif len(sub) != soln_count:
            self.assertTrue(False, "Proposed packing has incorrect number of tents.")
        else:
            # validate cover
            width, height = inputs["tent_size"]
            covered = inputs["rocks"]
            tent = [0 for _ in range(width*height)]
            xy = lambda x,y:x+y*width

            # mark rocks
            for rock_x, rock_y in inputs["rocks"]:
                tent[xy(rock_x,rock_y)] = "r"

            # mark tents
            for bag in sub:
                orientation = bag["orientation"]
                anchor = bag["anchor"]
                offset = (1,0) if orientation==0 else (0,1)

                squares = [ (anchor[0]+offset[0], anchor[1]+offset[1]),
                            anchor,
                            (anchor[0]+2*offset[0], anchor[1]+2*offset[1])]

                for (x,y) in squares:
                    loc = xy(x,y)
                    if loc > len(tent) -1:
                        self.assertTrue(False, "One of your sleeping bags is not in the tent")
                    if tent[xy(x,y)] == "r":
                        self.assertTrue(False, "Found a sleeping bag over a rock")
                    elif tent[xy(x,y)] == "b":
                        self.assertTrue(False, "Found overlapping sleeping bags")
                    else:
                        tent[xy(x,y)] = "b"


if __name__ == '__main__':
    res = unittest.main(verbosity=3, exit=False)
